/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model.panel;

import DE.siemens.ad.logo.app.comp.ToolBarLayout;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.BlockParameter;
import DE.siemens.ad.logo.model.IOParameter;
import DE.siemens.ad.logo.model.Parameter;
import DE.siemens.ad.logo.model.panel.BlockParameterPanel;
import DE.siemens.ad.logo.util.Language;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolTip;

public abstract class BlockNumberChangePanel
extends BlockParameterPanel {
    protected JPanel fInputPanel;
    JComboBox coboBlockNumber;
    JLabel lBlockNumber;
    JLabel fHelpLabel;
    private JTextArea fNumberChangeHelpText;
    private JScrollPane fNumberChangeHelpPane;

    public BlockNumberChangePanel() {
    }

    public BlockNumberChangePanel(Vector panels, Parameter parameterReference, boolean simulationMode) {
        super(panels, parameterReference, simulationMode);
        this.fInputPanel = new JPanel(new BorderLayout());
        this.addParameterPane(this.fInputPanel);
        JPanel panel = new JPanel(new ToolBarLayout(0));
        this.fInputPanel.add((Component)panel, "North");
        this.lBlockNumber = new JLabel("InputNumber");
        panel.add(this.lBlockNumber);
        this.coboBlockNumber = new JComboBox();
        panel.add(this.coboBlockNumber);
        this.fHelpLabel = new JLabel();
        panel.add(this.fHelpLabel);
    }

    private JTextArea getNumberChangeHelpText() {
        if (this.fNumberChangeHelpText == null) {
            this.fNumberChangeHelpText = new JTextArea();
            this.fNumberChangeHelpText.setText(Language.getString("blockNumberChangePanel.blockChangeHelpText", "All changes refer to the original block.\nSee dialog title!"));
            this.fNumberChangeHelpText.setLineWrap(true);
            this.fNumberChangeHelpText.setWrapStyleWord(true);
            this.fNumberChangeHelpText.setEditable(false);
            this.fNumberChangeHelpText.setBackground(new JToolTip().getBackground());
            this.fNumberChangeHelpPane = new JScrollPane(this.fNumberChangeHelpText);
            this.fInputPanel.add((Component)this.fNumberChangeHelpPane, "Center");
        }
        return this.fNumberChangeHelpText;
    }

    public boolean checkChanged() {
        if (!this.coboBlockNumber.getSelectedItem().equals(((BlockParameter)this.fParameterReference).getBlock().getNumberString())) {
            return true;
        }
        return super.checkChanged();
    }

    public void loadFieldContents() {
        Block block = ((BlockParameter)this.fParameterReference).getBlock();
        int[] freeInputNumbers = block.getWiringDiagram().getFreeNumbers(block.getNumberType());
        int actualNumber = block.getNumber();
        int insertPosition = -1;
        String numberPrefix = block.getNumberPrefix();
        if (freeInputNumbers.length > 0) {
            for (int i = 0; i < freeInputNumbers.length; ++i) {
                if (insertPosition < 0 && actualNumber < freeInputNumbers[i]) {
                    this.coboBlockNumber.addItem(block.getNumberString(actualNumber));
                    insertPosition = i;
                }
                this.coboBlockNumber.addItem(block.getNumberString(freeInputNumbers[i]));
            }
            if (actualNumber >= freeInputNumbers[freeInputNumbers.length - 1]) {
                this.coboBlockNumber.addItem(block.getNumberString(actualNumber));
                insertPosition = freeInputNumbers.length;
            }
        } else {
            this.coboBlockNumber.addItem(block.getNumberString(actualNumber));
            insertPosition = 0;
        }
        this.coboBlockNumber.setSelectedIndex(insertPosition);
        this.addBlockNumberChangeListener();
    }

    public abstract void setLabels();

    public void storeFieldContents() {
        String selectedBlock = this.coboBlockNumber.getSelectedItem().toString();
        ((IOParameter)this.fParameterReference).setBlockNumberString(selectedBlock);
    }

    private void addBlockNumberChangeListener() {
        this.coboBlockNumber.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BlockNumberChangePanel.this.numberChanged();
            }
        });
    }

    protected void numberChanged() {
        String s = this.coboBlockNumber.getSelectedItem().toString();
        this.getNumberChangeHelpText().setText(Language.getString("blockNumberChangePanel.blockChangeHelpText", "All changes refer to the original block.\nSee dialog title!", s));
        this.invalidate();
        this.revalidate();
        this.repaint();
    }
}

